using System.Data;
using System.Data.SqlClient;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/03/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		/// Static class implementing a data persistence logic for BOL.BloodProductModifications class.
		/// Retrieves from/saves to database BOL.BloodProductModifications class data. 
		///</summary>

		#endregion

	public class BloodProductModifications
	{

		///<Developers>
		///	<Developer>Carl Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/3/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1004"> 
		///		<ExpectedInput>Division code</ExpectedInput>
		///		<ExpectedOutput>DataTable containing existing product modifications</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1889"> 
		///		<ExpectedInput>Invalid DivisionCode</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retrieves from database list of existing product modifications 
		/// for specified division.
		/// </summary>
		/// <param name="divisionCode">Division code</param>
		/// <returns>List of product modifications</returns>
		public static DataTable GetExistingProductModifications(string divisionCode)
		{
			SqlParameter prm = new SqlParameter( STOREDPROC.GetProductModifications.divisioncode, System.Data.SqlDbType.VarChar );
			
			prm.Value = divisionCode;

			return Common.StoredProcedure.GetDataTable( STOREDPROC.GetProductModifications.StoredProcName, prm );
		}
	}
}






